<?php
/**
 * 2007-2025 PrestaShop.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author PrestaShop SA <contact@prestashop.com>
 *  @copyright  2007-2025 PrestaShop SA
 *  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */
require_once dirname(__FILE__) . '/../../config/config.inc.php';
require_once dirname(__FILE__) . '/../../init.php';
require_once dirname(__FILE__) . '/FunWishList.php';
require_once dirname(__FILE__) . '/tvcmswishlist.php';

$error = '';

// Instance of module class for translations
$module = new TvcmsWishList();

$token = Tools::getValue('token');
$id_product = (int) Tools::getValue('id_product');
$id_product_attribute = (int) Tools::getValue('id_product_attribute');
if (1 == Configuration::get('PS_TOKEN_ENABLE') && strcmp(Tools::getToken(false), Tools::getValue('static_token'))) {
    $error = $module->l('Invalid token', 'buywishlistproduct');
}

if (!Tools::strlen($error)
    && false === empty($token)
    && false === empty($id_product)) {
    $wishlist = FunWishList::getByToken($token);
    if (false !== $wishlist) {
        $cart = '';
        FunWishList::addBoughtProduct($wishlist['id_wishlist'], $id_product, $id_product_attribute, $cart->id, 1);
    }
} else {
    $error = $module->l('You must log in', 'buywishlistproduct');
}

if (false === empty($error)) {
    echo $error;
}
